library(MASS)
newsurvey <- na.omit(survey)

#1.  Install the dplyr package and import it.
install.packages('dplyr')
library(dplyr)

#2.  Filter all male left handers.
filter(newsurvey,Sex=="Male"&W.Hnd=="Left")

#3.  Display all female right handers who keep right on top while clapping.
filter(newsurvey,Sex=="Female"&W.Hnd=="Right"&Clap=="Right")

#4.  Display all students who never exercise.
filter(newsurvey,Exer=="None")

#5.  Display only the gender, age and writing hand of the students.
dplyr::select(newsurvey,Sex,Age,Wr.Hnd)

#6.  Display the age, pulse rate and writing hand span of female left handers.
newsurvey%>%
  dplyr::select(Sex,Age,Pulse,W.Hnd, Wr.Hnd) %>%
  filter(Sex=='Female',W.Hnd=='Left')